%%
%% This is file `dles15.cls'
%%

\NeedsTeXFormat{LaTeX2e}[1994/06/01]
\ProvidesClass{dles15}[DLES15]
\typeout{TYPESETTING in DLES15 symposium format ...}
\typeout{}

\LoadClass[twocolumn,a4paper]{article} %

\RequirePackage{dles15}  
\RequirePackage{graphics}  % standard package
\RequirePackage{graphicx}  % standard package
\RequirePackage{xcolor}
\RequirePackage{enumitem}
\RequirePackage{amsmath}

%%%%%%%%%%%%%%%%%%%%
% General layout
%
\setlength{\topmargin}{0mm}
\setlength{\headsep}{0mm}
\setlength{\footskip}{16pt}
\setlength{\columnsep}{10mm}
\setlength{\textheight}{230mm}
\setlength{\textwidth}{160mm}
\setlength{\oddsidemargin}{0mm}
\setlength{\evensidemargin}{0mm}
\renewcommand{\baselinestretch}{1.05}

\let\@date\@empty
\doublehyphendemerits=100000
\setlength\hfuzz{3pt} % reduce the quantity of \overfull warnings

\setitemize{noitemsep,topsep=0pt,parsep=0pt,partopsep=0pt}

\AtBeginDocument{
\setlength{\abovedisplayskip}{4pt}
\setlength{\belowdisplayskip}{4pt}
\setlength{\abovedisplayshortskip}{2pt}
\setlength{\belowdisplayshortskip}{2pt}
}

%%%%%%%%%%%%%%%%%%
% Modify floatings
%

  \renewcommand{\topfraction}{0.9}
  \renewcommand{\bottomfraction}{0.9}
  \renewcommand{\textfraction}{0.1}
  \renewcommand{\floatpagefraction}{0.8}
  \renewcommand{\dbltopfraction}{\floatpagefraction}
  \renewcommand{\dblfloatpagefraction}{\floatpagefraction}

  \setcounter{topnumber}{10}
  \setcounter{dbltopnumber}{\value{topnumber}}
  \setcounter{bottomnumber}{\value{topnumber}}
  \setcounter{totalnumber}{\value{topnumber}}
  \addtocounter{totalnumber}{\value{bottomnumber}}


  \setlength{\floatsep}        { 5pt plus 2pt minus 2pt}
  \setlength{\textfloatsep}    { 5pt plus 2pt minus 3pt}
  \setlength{\intextsep}       { 5pt plus 2pt minus 2pt}
  \setlength{\dblfloatsep}     {\floatsep}
  \setlength{\dbltextfloatsep} {\textfloatsep}

\renewcommand{\and}{\\*[-8pt]}

%%%%%%%%%%%%%%%%%%%%%
% Title
%

\def\@maketitle{%
  \newpage
  \begin{center}%
  \let \footnote \thanks
  \parbox{150mm}{\centering
  \setlength{\baselineskip}{17pt}
   {\Large{\sffamily\bfseries\MakeUppercase
   {\@title}}}}
   \par%
    \vskip 30pt%
    {\large{\textsf\@author}}
    \par%
    \vskip 1em%
  \end{center}%
  \par%
  \vskip 1em%
}

%%%%%%%%%%%%%%%%%%%%%%%
% Sectioning
%

\setcounter{secnumdepth}{-2}% instead of having to use the *'d
                            % section commands

\renewcommand{\section}[1]{
\par
\vspace{16pt}
\noindent\textsf{\textbf{\MakeUppercase{#1}}}
\par
\vspace{2pt}
}
\renewcommand{\subsection}[1]{
\par
\vspace{16pt}
\noindent\textsf{\textbf{#1}}
\par
}
\renewcommand{\subsubsection}[1]{%
\par
\vspace{16pt}
\textsf{\textbf{#1.}}}

\renewcommand\paragraph{\@startsection{paragraph}{4}%
  {\parindent}%
  {0.3ex}%
  {-1em}%
  {\normalfont\normalsize\sffamily}}
\renewcommand\subparagraph{\@startsection{subparagraph}{5}%
  {\parindent}%
  {0.3ex}%
  {-1em}%
  {\normalfont\normalsize\itshape}}
\listfiles

\newenvironment{References}{
\par\vspace{6pt}\noindent\textsf{\textbf{REFERENCES}}\par\vspace{-3pt}
\begin{small}
\begin{list}{ }{\itemsep0mm \parsep0mm\labelsep6pt\leftmargin12pt}} {\end{list}\end{small}}

\endinput

%%
%% End of file `dles15.cls'
%%