%%
%% This is file `edrfcm.cls',

\NeedsTeXFormat{LaTeX2e}[1994/06/01]
\ProvidesClass{edrfcm10}[2009/12/24 modified EDRM document class]
\typeout{TYPESETTING in EDRM symposium format ...}
\typeout{}

\LoadClass[twoside]{article} %

\RequirePackage{edrfcm10}  %edrm.sty provided in the filepackage
\RequirePackage{graphics}  %Standars package
\RequirePackage{graphicx}  %Standard package
\RequirePackage{wrapfig}   %Standard package
\RequirePackage{rotating}  %Standard package
\RequirePackage{cite}  	   %Standard package

%%%%%%%%%%%%%%%%%%%%
% General layout
%
 
\setlength{\topmargin}{-5mm}
%\setlength{\topmargin}{0mm}
\setlength{\headsep}{0mm}
\setlength{\footskip}{32pt}
%\setlength{\textheight}{240.0mm}
\setlength{\textheight}{243.4mm}
%\setlength{\textwidth}{169.7mm}
\setlength{\textwidth}{165mm}
\setlength{\columnsep}{9.53mm}
\setlength{\evensidemargin}{\oddsidemargin}
\renewcommand{\baselinestretch}{1.2}



\let\@date\@empty
\doublehyphendemerits=100000
\setlength\hfuzz{3pt}    % reduce the quantity of \overfull warnings


%%%%%%%%%%%%%%%%%%
% Modify floatings
%
  \renewcommand{\topfraction}{0.9}
  \renewcommand{\bottomfraction}{0.9}
  \renewcommand{\textfraction}{0.1}
  \renewcommand{\floatpagefraction}{0.8}
  \renewcommand{\dbltopfraction}{\floatpagefraction}
  \renewcommand{\dblfloatpagefraction}{\floatpagefraction}
  
  \setcounter{topnumber}{10}
  \setcounter{dbltopnumber}{\value{topnumber}}
  \setcounter{bottomnumber}{\value{topnumber}}
  \setcounter{totalnumber}{\value{topnumber}}
  \addtocounter{totalnumber}{\value{bottomnumber}}

  
  \setlength{\floatsep}        { 5pt plus 2pt minus 2pt}
  \setlength{\textfloatsep}    { 5pt plus 2pt minus 3pt}
  \setlength{\intextsep}       { 5pt plus 2pt minus 2pt}
  \setlength{\dblfloatsep}     {\floatsep}
  \setlength{\dbltextfloatsep} {\textfloatsep}
	
\renewcommand{\and}{\\*[-8pt]}

%%%%%%%%%%%%%%%%%%%%%
% Contents 
% 

\renewcommand\tableofcontents{%
    \section{\contentsname
        \@mkboth{%
           \MakeUppercase\contentsname}{\MakeUppercase\contentsname}}%
    \@starttoc{toc}%
    }

\newcommand{\TOCabstract}[2]{
\addcontentsline{toc}{subsection}{\protect\numberline{}{\hspace*{-7.0mm}%
{\sffamily\bfseries #1}~\/~\sffamily#2}}
}

%%%%%%%%%%%%%%%%%%%%%
% Title
% 

\newcommand\Maketitle[3]{%
  \newpage
\parbox{\textwidth}{
\begin{flushright}
{\bf%
European Drag Reduction and Flow Control Meeting -- EDRFCM 2010 \\
September 7--10, 2010, Kyiv, Ukraine \\ \vspace{5mm}}
\end{flushright}
}
%
  \begin{center}%  
  \parbox{160mm}{\centering
  \setlength{\baselineskip}{18pt}
   {\Large{\sffamily\bfseries\MakeUppercase{#1}}}
   \par%
    \vskip 12pt%
    {\large{\sffamily\bfseries{#2}}}
    \par%
    \vskip 12pt%
    {\large{\sffamily{#3 \\ \vskip -10pt}}}}
    \vskip 0.3em%
  \end{center}%
  \par%
  \vskip 0.5em%
%\TOCabstract{#2}{#1}
}


%%%%%%%%%%%%%%%%%%%%%%%
% Sectioning
%

\setcounter{secnumdepth}{-2}% instead of having to use the *'d
                            % section commands

\renewcommand{\section}[1]{
\par
\vspace{16pt}
\noindent\textsf{\textbf{\MakeUppercase{#1}}}
\par
\vspace{2pt}
}
\renewcommand{\subsection}[1]{
\par
\vspace{16pt}
\noindent\textsf{\textbf{#1}}
\par
}
\renewcommand{\subsubsection}[1]{%
\par
\vspace{16pt}
\textsf{\textbf{#1.}}}


%%


\renewenvironment{thebibliography}[1]
     {\section{\refname}%
      \@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}%
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}

%\listfiles
\endinput
%% End of file
